<?php

class LWUCI_Connector {

	public $wuiPassword;
	
	protected $baseCommand;
	protected $read;
	protected $write;
  
	public function __construct() {
		global $_SESSION;
		$this->baseCommand = "lwconfig -n ";
		$this->read = "read ";
		$this->write = "write ";
	}
	
	/**
	 * Read one value from configuration
	 * @param unknown_type $param -> string constant
	 * @return string
	 */
	function read($param) {

/* U_M39G_MV-2251 M39G_MV_2-2500 */
	$STA_Authentication["OPEN"] ="OPEN";
	$STA_Authentication["WPA_PSK"] = "WPA_PSK";
	$STA_Authentication["WPA_PSK_VOL"] = "WPA_PSK";
	$STA_Authentication["WEP_HEX1"] = "WEP_HEX1";
	$STA_Authentication["WEP_HEX2"] = "WEP_HEX2";
	$STA_Authentication["WEP_HEX3"] = "WEP_HEX3";
	$STA_Authentication["WEP_HEX4"] = "WEP_HEX4";
	$STA_Authentication["WEP_ASCII1"] = "WEP_ASCII1";
	$STA_Authentication["WEP_ASCII2"] = "WEP_ASCII2";
	$STA_Authentication["WEP_ASCII3"] = "WEP_ASCII3";
	$STA_Authentication["WEP_ASCII4"] = "WEP_ASCII4";
	$STA_Authentication["WEP_HEX1_VOL"] = "WEP_HEX1";
	$STA_Authentication["WEP_HEX2_VOL"] = "WEP_HEX2";
	$STA_Authentication["WEP_HEX3_VOL"] = "WEP_HEX3";
	$STA_Authentication["WEP_HEX4_VOL"] = "WEP_HEX4";
	$STA_Authentication["WEP_ASCII1_VOL"] = "WEP_ASCII1";
	$STA_Authentication["WEP_ASCII2_VOL"] = "WEP_ASCII2";
	$STA_Authentication["WEP_ASCII3_VOL"] = "WEP_ASCII3";
	$STA_Authentication["WEP_ASCII4_VOL"] = "WEP_ASCII4";
	$STA_Authentication["WEP_HEX1_SH"] = "WEP_HEX1_SH";
	$STA_Authentication["WEP_HEX2_SH"] = "WEP_HEX2_SH";
	$STA_Authentication["WEP_HEX3_SH"] = "WEP_HEX3_SH";
	$STA_Authentication["WEP_HEX4_SH"] = "WEP_HEX4_SH";
	$STA_Authentication["WEP_ASCII1_SH"] = "WEP_ASCII1_SH";
	$STA_Authentication["WEP_ASCII2_SH"] = "WEP_ASCII2_SH";
	$STA_Authentication["WEP_ASCII3_SH"] = "WEP_ASCII3_SH";
	$STA_Authentication["WEP_ASCII4_SH"] = "WEP_ASCII4_SH";
	$STA_Authentication["WEP_HEX1_VOL_SH"] = "WEP_HEX1_SH";
	$STA_Authentication["WEP_HEX2_VOL_SH"] = "WEP_HEX2_SH";
	$STA_Authentication["WEP_HEX3_VOL_SH"] = "WEP_HEX3_SH";
	$STA_Authentication["WEP_HEX4_VOL_SH"] = "WEP_HEX4_SH";
	$STA_Authentication["WEP_ASCII1_VOL_SH"] = "WEP_ASCII1_SH";
	$STA_Authentication["WEP_ASCII2_VOL_SH"] = "WEP_ASCII2_SH";
	$STA_Authentication["WEP_ASCII3_VOL_SH"] = "WEP_ASCII3_SH";
	$STA_Authentication["WEP_ASCII4_VOL_SH"] = "WEP_ASCII4_SH";


		
		if ($param == "pageOverview") {
			$myReturn = [];
			$iccid = shell_exec($this->baseCommand . $this->read . "sim_current_iccid");
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
			//~ $returnVal = shell_exec($this->baseCommand . $this->read . "modem_imei");
			//~ $myReturn["about"]["imei"] = ($returnVal == null)? "" : $returnVal;
			//~ $returnVal = shell_exec($this->baseCommand . $this->read . "modem_swversion");
			//~ $myReturn["about"]["modem_swver"] = ($returnVal == null)? "" : $returnVal;
			//~ $returnVal = shell_exec($this->baseCommand . $this->read . "sw_buildtime");
			//~ $myReturn["about"]["serial"] = ($returnVal == null)? "" : $returnVal;
			//~ $returnVal = shell_exec($this->baseCommand . $this->read . "sw_buildtime");
			//~ $myReturn["about"]["sw_version"] = ($returnVal == null)? "" : "u-blox build " . $returnVal;

/* U_M39G_MV-2327 M39G_MV_2-2500 */
			$returnVal2 = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_internet_profile");
			if ($returnVal2 == null) {
				$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
				$myReturn["settings"]["internet"]["connName"] = ($returnVal == null)? "" : $returnVal;
			}
			else {
				$myReturn["settings"]["internet"]["connName"] = $returnVal2;
			}
/* U_M39G_MV-2327 M39G_MV_2-2500 	$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_internet_profile");
			$myReturn["settings"]["internet"]["connName"] = ($returnVal == null)? "" : $returnVal;*/
			$returnVal = shell_exec($this->baseCommand . $this->read . "modemMan_enable");
			$myReturn["settings"]["internet"]["dialin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_roaming");
			$myReturn["settings"]["internet"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_language");
			$myReturn["settings"]["system"]["language"] = (($returnVal == null) || ($returnVal == ""))? "en" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_password");
			$myReturn["settings"]["system"]["password"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_password_validity");
			$myReturn["settings"]["system"]["pass_prot"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_iface_uap0_address");
			$myReturn["settings"]["wlan"]["ip"] = ($returnVal == null)? "" : $returnVal;
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
			//~ $returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_mode");
			//~ $myReturn["settings"]["wlan"]["mode"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_security_mode");
			$myReturn["settings"]["wlan"]["encrypt"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_ssid");
			$myReturn["settings"]["wlan"]["ssid"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_inserted");
			$myReturn["sim_status"]["inserted"] = ($returnVal == null)? 0 : ($returnVal == "y")? 1 : 0;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_status");
			$myReturn["sim_status"]["pin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_downbytes");
			$myReturn["status"]["modem"]["down"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_ip");
			$myReturn["status"]["modem"]["ip"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["status"]["modem"]["operator"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_upbytes");
			$myReturn["status"]["modem"]["up"] = ($returnVal == null)? "" : $returnVal;
//******************************************************************************
//* reading wlan client from system information                                *
//******************************************************************************
			$DNS_LEASE_FILE="/tmp/mrvlsys/dnsmasq.leases";
			$CONNECTED = shell_exec("8787_uaputl.exe sta_list");
			$CONNECTED = explode(" ",$CONNECTED);
			
			// read DHCP lease file for client name / IP resolution
			$DNSMASQ = $this->readTextFile($DNS_LEASE_FILE);
			$DNSMASQ = explode(" ",$DNSMASQ);
			
			// read ARP cache for client IP resolution
			$ARPCACHE = shell_exec("arp -a -n");
			$ARPCACHE = explode(" ",$ARPCACHE);
			
			// generate a 'useful' list out of that (this will work in a for-loop)
			$i = 0;
			$ConnStations = [];
			foreach ($CONNECTED as $key1 => $value1) {
				if ($value1 == "Address:") {
					$MACADDR = substr($CONNECTED[$key1+1],0,17);
					$ConnStations[$i]['MAC'] = $MACADDR;
					$ConnStations[$i]['name'] = $MACADDR;
					$ConnStations[$i]['ip'] = "";

					$found = FALSE;
					// look for name / IP in DHCP leases
					foreach ($DNSMASQ as $key2 => $value2) {
						if($value2 == $MACADDR) {
							$ConnStations[$i]['ip'] = $DNSMASQ[$key2+1];
							$ConnStations[$i]['name'] = $DNSMASQ[$key2+2];
							$found = TRUE;
							break;
						}
					}
					if (!$found) {
						// look for IP in arp cache
						foreach ($ARPCACHE as $key2 => $value2) {
							if ($value2 == $MACADDR) {
								$ConnStations[$i]['ip'] = substr($ARPCACHE[$key2-2], 1, -1);
								$found = TRUE;
								break;
							}
						}
					}
					$i++;
				}
			}

			$myReturn["conn_devs"]["wlan"] = $ConnStations;
//******************************************************************************
			return $myReturn;
		} else if ($param == "pageInternet") {
			$myReturn = [];
			$iccid = shell_exec($this->baseCommand . $this->read . "sim_current_iccid");
			$myReturn["settings"]["internet"]["iccid"] = ($iccid == null)? "" : $iccid;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_apn");
			$myReturn["settings"]["internet"]["apn"] = ($returnVal == null)? "" : $returnVal;
/* M39G_MV_2-984 */
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_apn4G");
			$myReturn["settings"]["internet"]["apn4G"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_authentication");
			$myReturn["settings"]["internet"]["auth"] = ($returnVal == null)? "NONE" : ($returnVal == "")? "NONE" : $returnVal;

/* U_M39G_MV-2327 M39G_MV_2-2500 */
			$returnVal2 = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_internet_profile");
			if ($returnVal2 == null) {
				$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
				$myReturn["settings"]["internet"]["connName"] = ($returnVal == null)? "" : $returnVal;
			}
			else {
				$myReturn["settings"]["internet"]["connName"] = $returnVal2;
			}
/* U_M39G_MV-2327 M39G_MV_2-2500	$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["settings"]["internet"]["connName"] = ($returnVal == null)? "" : $returnVal;*/
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_dns1");
			$myReturn["settings"]["internet"]["dns1"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_dns2");
			$myReturn["settings"]["internet"]["dns2"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_roaming");
			$myReturn["settings"]["internet"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_user_name");
			$myReturn["settings"]["internet"]["user"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_" . $iccid . "_user_pass");
			$myReturn["settings"]["internet"]["pass"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_language");
			$myReturn["settings"]["system"]["language"] = (($returnVal == null) || ($returnVal == ""))? "en" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_password_validity");
			$myReturn["settings"]["system"]["pass_prot"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_status");
			$myReturn["sim_status"]["pin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_inserted");
			$myReturn["sim_status"]["inserted"] = ($returnVal == null)? 0 : ($returnVal == "y")? 1 : 0;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_downbytes");
			$myReturn["status"]["modem"]["down"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["status"]["modem"]["operator"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_upbytes");
			$myReturn["status"]["modem"]["up"] = ($returnVal == null)? "" : $returnVal;
			return $myReturn;
		} else if ($param == "pageWlanAp") {
			$myReturn = [];
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_language");
			$myReturn["settings"]["system"]["language"] = (($returnVal == null) || ($returnVal == ""))? "en" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_password_validity");
			$myReturn["settings"]["system"]["pass_prot"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_channel");
			$myReturn["settings"]["wlan"]["channel"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_security_mode");
			$myReturn["settings"]["wlan"]["encrypt"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_iface_uap0_address");
			$myReturn["settings"]["wlan"]["ip"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_mode");
			$myReturn["settings"]["wlan"]["mode"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_security_key");
			$myReturn["settings"]["wlan"]["pass"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_country");
			$myReturn["settings"]["wlan"]["region"] = ($returnVal == null)? "" : $returnVal;
/* M39G_MV_2-760 */
			$returnVal = shell_exec($this->baseCommand . $this->read . "region_blocked");
			$myReturn["settings"]["wlan"]["region_blocked"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_uap0_ssid");
			$myReturn["settings"]["wlan"]["ssid"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_iface_uap0_netmask");
			$myReturn["settings"]["wlan"]["subnet"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_status");
			$myReturn["sim_status"]["pin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_inserted");
			$myReturn["sim_status"]["inserted"] = ($returnVal == null)? 0 : ($returnVal == "y")? 1 : 0;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_downbytes");
			$myReturn["status"]["modem"]["down"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["status"]["modem"]["operator"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_upbytes");
			$myReturn["status"]["modem"]["up"] = ($returnVal == null)? "" : $returnVal;
			return $myReturn;
		} else if ($param == "pageWlanSta") {
			$myReturn = [];
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_language");
			$myReturn["settings"]["system"]["language"] = (($returnVal == null) || ($returnVal == ""))? "en" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_mlan0_enable");
			$myReturn["settings"]["wlan"]["sta"]["enable"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_mlan0_ssid");
			$myReturn["settings"]["wlan"]["sta"]["ssid"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_mlan0_security_mode");
/* U_M39G_MV-2251 M39G_MV_2-2500 */
			$myReturn["settings"]["wlan"]["sta"]["security_mode"] = ($returnVal == null)? "" : $STA_Authentication[$returnVal];
			$returnVal = shell_exec($this->baseCommand . $this->read . "wibear_mlan0_security_key");
			$myReturn["settings"]["wlan"]["sta"]["security_key"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_iface_mlan0_dhcp");
			$myReturn["settings"]["wlan"]["sta"]["dhcp"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_iface_mlan0_address");
			$myReturn["settings"]["wlan"]["sta"]["address"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_iface_mlan0_netmask");
			$myReturn["settings"]["wlan"]["sta"]["netmask"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_mlan0_gateway");
			$myReturn["settings"]["wlan"]["sta"]["gateway"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "net_mlan0_nameservers");
			$myReturn["settings"]["wlan"]["sta"]["nameservers"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_status");
			$myReturn["sim_status"]["pin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_inserted");
			$myReturn["sim_status"]["inserted"] = ($returnVal == null)? 0 : ($returnVal == "y")? 1 : 0;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_downbytes");
			$myReturn["status"]["modem"]["down"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["status"]["modem"]["operator"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_upbytes");
			$myReturn["status"]["modem"]["up"] = ($returnVal == null)? "" : $returnVal;
			return $myReturn;
		} else if ($param == "pageSystem") {
			$myReturn = [];
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_language");
			$myReturn["settings"]["system"]["language"] = (($returnVal == null) || ($returnVal == ""))? "en" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_password_validity");
			$myReturn["settings"]["system"]["pass_prot"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "modemMan_enable");
			$myReturn["settings"]["internet"]["dialin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_status");
			$myReturn["sim_status"]["pin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_inserted");
			$myReturn["sim_status"]["inserted"] = ($returnVal == null)? 0 : ($returnVal == "y")? 1 : 0;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_downbytes");
			$myReturn["status"]["modem"]["down"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["status"]["modem"]["operator"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_upbytes");
			$myReturn["status"]["modem"]["up"] = ($returnVal == null)? "" : $returnVal;
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_access_enable");
			$myReturn["settings"]["system"]["wui_access"] = ($returnVal == null)? 0 : $returnVal;
			return $myReturn;
		} else if ($param == "pageAjax") {
			$myReturn = [];
			$iccid = shell_exec($this->baseCommand . $this->read . "sim_current_iccid");
			$myReturn["settings"]["internet"]["iccid"] = ($iccid == null)? "" : $iccid;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_status");
			$myReturn["sim_status"]["pin"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_inserted");
			$myReturn["sim_status"]["inserted"] = ($returnVal == null)? 0 : ($returnVal == "y")? 1 : 0;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_downbytes");
			$myReturn["status"]["modem"]["down"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_operator");
			$myReturn["status"]["modem"]["operator"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_radio");
			$myReturn["status"]["modem"]["radio"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_roaming");
			$myReturn["status"]["modem"]["roaming"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_session_status");
			$myReturn["status"]["modem"]["session"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_signal");
			$myReturn["status"]["modem"]["signal"] = ($returnVal == null)? "" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "sim_current_upbytes");
			$myReturn["status"]["modem"]["up"] = ($returnVal == null)? "" : $returnVal;
			return $myReturn;
		} else if ($param == "pageAbout") {
			$myReturn = [];
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_language");
			$myReturn["settings"]["system"]["language"] = (($returnVal == null) || ($returnVal == ""))? "en" : $returnVal;
			$returnVal = shell_exec($this->baseCommand . $this->read . "wui_password_validity");
			$myReturn["settings"]["system"]["pass_prot"] = (($returnVal == null) || ($returnVal == ""))? "" : $returnVal;
			return $myReturn;
		} else {
			return shell_exec($this->baseCommand . $this->read . $param);
		}
	}
	
	/**
	 * Write para string into configuration
	 * @param unknown_type $param -> formatted string of key-value pairs
	 */
	function write($param) {
		$params = "";
		if(is_array($param)) {
			$param_count = count($param);
			foreach($param as $key => $value) {
				$param_count--;
				$params .= $key . " " . escapeshellarg($value);
				if( $param_count ) {
					$params .= " ";
				}
			}
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
			$command = $this->baseCommand . $this->write . $params;
			return shell_exec($command);
		}
/* TOBY_L200_50S-202 */ /* M39G_MV_2-380 */
		return;
	}

	function setLang($langCode){
		if(!empty($langCode)) {
			$this->write("wui_language ".$langCode);
		}
	}
	function getWuiPassword() {
		return shell_exec($this->baseCommand . $this->read . "wui_password");
	}
	
	function readTextFile($file) {
		if (file_exists($file)) {
			$text = file_get_contents($file);
		} else {
			$text = "";
		}
		return $text;
	}
	
	function startsWith($haystack, $needle)
	{
		return $needle === "" || strpos($haystack, $needle) === 0;
	}
	
	function endsWith($haystack, $needle)
	{
		return $needle === "" || substr($haystack, -strlen($needle)) === $needle;
	}
}

?>

