<?php
/*
 * Class ServiceProviders is used to determine the supported
 * network profiles upon SIM inserting.
 * 
 * This code was built upon https://git.gnome.org/browse/mobile-broadband-provider-info/tree/
 *  - serviceproviders.xml contains the database
 *	- serviceproviders.2.dtd contains the XML rules which is used in this code
 *
 * Example usage:
 * 	- Create ServiceProviders( (string)$mcc, (string)$mnc, (string)$usage ) class:
 *		# mcc		- (string) mcc number, REQUIRED
 *		# mnc		- (string) mnc number, REQUIRED
 *		# usage		- (string) usage mode (internet|mms|wap), OPTIONAL (default: internet)
 *
 *		$sp = new ServiceProviders("216","01");
 *
 *	- Print found profiles with ServiceProviders->getResults( (bool)$toJSON ) function
 *		# $toJSON	- (bool) encode result to JSON, OPTIONAL (default: false)
 *
 *		print_r( $sp->getResults() );
 *
 * $Revision: 4105 $
 * $Author: PENET\roncsak $
 * $Date: 2014-06-17 13:08:21 +0200 (Tue, 17 Jun 2014) $
 *
 **/
 
// if( empty($http) ) {
	// $http = $_REQUEST;
// }

class ServiceProviders {

	private $serviceproviders_file = SERVICE_PROVIDERS;
	private $xmlIterator;
	
	private $mcc;
	private $mnc;
	private $usage;
	
	private $allowed_usages = array("internet", "mms", "wap");
	
	public function __construct( $mcc=null, $mnc=null, $usage="internet" ) {
		
		// MCC & MNC cannot be empty and must be a string
		if( empty($mcc) || !is_string($mcc) || empty($mnc) || !is_string($mnc) ) {
			return -1;
		}
		
		// usage is strict
		if( !in_array($usage, $this->allowed_usages) ) {
			return -1;
		}
		
		// check file exists
		if(!file_exists($this->serviceproviders_file)) {
			return -1;
		}
		
		$this->mcc = $mcc;
		$this->mnc = $mnc;
		$this->usage = $usage;
		// print "start";
		// $this->xmlIterator = simplexml_load_file($this->serviceproviders_file, "SimpleXMLIterator");
	}
	
	public function getResults($toJSON = false) {
		if( !is_bool($toJSON) ) {
			return -1;
		}
		$mccFound = false;
		$mncFound = false;
		$usageMatch = false;
	
		$xmlIterator = simplexml_load_file($this->serviceproviders_file, "SimpleXMLIterator");
		for( $xmlIterator->rewind(); $xmlIterator->valid(); $xmlIterator->next() ) {
			if( !$mccFound ) {
				unset($current);
				$current['country'] = (string) $xmlIterator->current()->attributes()->code;
				$providerIterator = $xmlIterator->current();
				
				$current['providers'] = array();
				for( $providerIterator->rewind(); $providerIterator->valid(); $providerIterator->next() ) {
					$providerNum = sizeof($current['providers']);
					$current['providers'][$providerNum]['name'] = (string) $providerIterator->current()->name;
					$current['providers'][$providerNum]['hasGSM'] = ( property_exists( $providerIterator->current(), "gsm" ) )? "1" : "0";
					$current['providers'][$providerNum]['hasCDMA'] = ( property_exists( $providerIterator->current(), "cdma" ) )? "1" : "0";
					$providerChildIterator = $providerIterator->current();
					for( $providerChildIterator->rewind(); $providerChildIterator->valid(); $providerChildIterator->next() ) {
						if( $providerChildIterator->current()->getName() == "gsm" ) {
							$gsmIterator = $providerChildIterator->current();
							for( $gsmIterator->rewind(); $gsmIterator->valid(); $gsmIterator->next() ) {
								if( $gsmIterator->current()->getName() == "network-id" ) {
									if( $gsmIterator->current()->attributes()->mcc == $this->mcc && $gsmIterator->current()->attributes()->mnc == $this->mnc ) {
										// print "mcc found <br />";
										// $gsmNum = sizeof($current['providers'][$providerNum]['gsm_networks']);
										$current['providers'][$providerNum]['gsm']["mcc"] = (string) $gsmIterator->current()->attributes()->mcc;
										$current['providers'][$providerNum]['gsm']["mnc"] = (string) $gsmIterator->current()->attributes()->mnc;
										$mncFound = true;
										$mccFound = true;
										break;
									}
								}
							}
							if( !empty($current['providers'][$providerNum]['gsm']) ) {
								$current['providers'][$providerNum]['gsm']["apns"] = array();
								for( $gsmIterator->rewind(); $gsmIterator->valid(); $gsmIterator->next() ) {
									if( $gsmIterator->current()->getName() == "apn" ) {
										$apnNum = sizeof($current['providers'][$providerNum]['gsm']["apns"]);
										$current['providers'][$providerNum]['gsm']["apns"][$apnNum]["apn"] = (string) $gsmIterator->current()->attributes()->value;
										$apnIterator = $gsmIterator->current();
										
										$planNum = 1;
										$nameNum = 1;
										$dnsNum = 1;
										for( $apnIterator->rewind(); $apnIterator->valid(); $apnIterator->next() ) {
											switch( $apnIterator->current()->getName() ) {
												case  "plan":		// Zero or More Occurrences
																	// (prepaid|postpaid)
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['plan'.$planNum++] = (string) $apnIterator->current()->attributes()->type;
													break;
												case  "usage":		// Zero or One Occurrences
																	// (internet|mms|wap)
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['usage'] = (string) $apnIterator->current()->attributes()->type;
													break;
												case  "name":		// Zero or More Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['name'.$nameNum++] = (string) $apnIterator->current();
													break;
												case  "gateway":	// Zero or One Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['gateway'] = (string) $apnIterator->current();
													break;
												case  "username":	// Zero or One Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['username'] = (string) $apnIterator->current();
													break;
												case  "password":	// Zero or One Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['password'] = (string) $apnIterator->current();
													break;
												case  "dns":		// Zero or More Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['dns'.$dnsNum++] = (string) $apnIterator->current();
													break;
												case  "mmsc":		// Zero or One Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['mmsc'] = (string) $apnIterator->current();
													break;
												case  "mmsproxy":	// Zero or One Occurrences
													$current['providers'][$providerNum]['gsm']["apns"][$apnNum]['mmsproxy'] = (string) $apnIterator->current();
													break;
												default:
													break;
											}
										}
										// Remove apn if it's not match against "usage"
										if( $current['providers'][$providerNum]['gsm']["apns"][$apnNum]['usage'] != $this->usage ) {
											unset($current['providers'][$providerNum]['gsm']["apns"][$apnNum]);
										}
									}
								}
								// }
							} else {
								unset($current['providers'][$providerNum]);
							}
							
						/*
						 *	TODO
						 *
						 *	CDMA networks does not have apn settings
						 *	and currently this code won't find CDMA network profiles.
						 *
						 *	Uncomment the next "comment section" to start implementing CDMA profiles
						 * */
						// } else if( $providerChildIterator->current()->getName() == "cdma" ) {
							// [code goes here]
						}
					}
				}
			} else {
				break;
			}
		}
		if( $toJSON ) {
			// $current = json_encode($current, JSON_PRETTY_PRINT);
			$current = json_encode($current);
		}
		return $current;
	}
}

// require_once('init.php'); // remove this
// $sp = new ServiceProviders("262","02", "internet");
// print "<pre>";
// print_r( $sp->getResults(true) );
// print "</pre>";
?>