#!/bin/sh

TEMP_DIR=/mrvlsys

SYSTEM_CONFIG_HOST=`getprop persist.sys.ublx_cmdline.SYCG 0`
IP_TERMINATION_AUX=`getprop persist.sys.ublx_cmdline.IPTM 0`

IMS_ENABLE=`getprop persist.sys.ublx_cmdline.IMSC 0`
# M39G_MV_2-2500 removed reference to MIFI
GPS_AUX=`getprop persist.sys.ublx_cmdline.GPSC 0`
#IP_ADDRESS=`getprop persist.mrvl.net.static_ip`
# M39G_MV_2-364
##### Lesswire modifications #####
#WIFI_ENABLE=`grep "WIFI=1" $CmdLine|wc -l`
WIFI_ENABLE=`getprop ro.cmdline.WIFI`
##### Lesswire modifications #####
##### u-blox modifications #####
#U_M39G_MV-89
#defined also in teldev.h
NVMIptables=/NVM/iptables_nvm.sh
##### u-blox modifications #####

#setup loopback interface needed by mtil sockets
ifconfig lo up

#*** u-blox modifications ***
#U_M39G_MV-1380
IPTABLES_CMD=`which iptables`
DNSMASQ_CMD=`which dnsmasq`

RNDIS0_DHCPSTART=`getprop persist.sys.ublx_rndis0_dhcpst`
RNDIS0_DHCPSTOP=`getprop persist.sys.ublx_rndis0_dhcpsp`

if [ -z "RNDIS0_DHCPSTART" ] || [ -z "RNDIS0_DHCPSTOP" ]; then
	setprop persist.sys.ublx_rndis0_dhcpst 192.168.1.100
	setprop persist.sys.ublx_rndis0_dhcpsp 192.168.1.100
	RNDIS0_DHCPSTART=`getprop persist.sys.ublx_rndis0_dhcpst`
	RNDIS0_DHCPSTOP=`getprop persist.sys.ublx_rndis0_dhcpsp`
fi
# M39G_MV_2-741
StartWiFiDelayed()
{
	# wait Proxy server to load, UGPIOC must be ready
	sleep 5
	echo "Running WiFi Services..." >> /dev/kmsg
	./run_wifi.sh init
}
#*** u-blox modifications ***

#GPS in Aux
if [ $GPS_AUX = '5' ]; then
	echo "Running GPS..." >> /dev/kmsg
#	sed 's/\(.*peIpAddrOfAppIf[^=]*=[[:space:]]*\).*/\1'"$IP_ADDRESS"'/' -i /data/mrvlgps/mrvl_gps_platform.conf
#	sed 's/\(.*peIpAddrOfAppIf[^=]*=[[:space:]]*\).*/\1'"$IP_ADDRESS"'/' -i /data/mrvlgps/mrvl_gps_platform_e2b0.conf
	./run_gps.sh
else
	# this is a WA for GPS power leackage in Omer Board.
	echo "enable GPS LDO to prevent current leackage" >> /dev/kmsg
	echo "power 1" > /proc/driver/gps88Lx000
fi

#U_M39G_MV-139, U_M39G_MV-1533 M39G_MV_2-607
UBLOX_UIMSENABLED=`getprop persist.sys.ublx_uimsenabled`

#IMS
if [ $UBLOX_UIMSENABLED = '1' ]; then
	echo "Running IMS..." >> /dev/kmsg
	./run_ims.sh &
fi

# M39G_MV_2-2500 removed reference to MIFI

# Termination in Aux
if [ $IP_TERMINATION_AUX = '5' ]; then
	if [ $SYSTEM_CONFIG_HOST = '2' ]; then
		#System in Host i.e. DATACARD
		echo "Running APX Service..." >> /dev/kmsg
		./run_apx.sh datacard
# U_M39G_MV-2291M39G_MV_2-2500
		if [ $WIFI_ENABLE = '1' ]; then
			#System in Target i.e. simple hostless
# U_M39G_MV-2291 M39G_MV_2-2500
			echo "Running U-blox Wi-Fi in ROUTER..." >> /dev/kmsg
			#NAT rules:
#*** u-blox modifications ***
# U_M39G_MV-1380
			if [ $IPTABLES_CMD ]; then
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet0 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet0 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet0 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet1 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet1 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet1 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet2 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet2 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet2 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet3 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet3 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet3 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet4 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet4 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet4 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet5 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet5 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet5 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet6 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet6 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet6 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet7 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet7 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet7 -j ACCEPT
			fi
#*** u-blox modifications ***			

			# Special rules for a new session starts from NW to PC
			#
			# Note:
			# 1. It relays on DHCP address allocation (currently hard coded)
			# 2. This rules are for development only and should be removed in a product!
			#./iptables -A PREROUTING -t nat -i ccinet0 -j DNAT --to-destination 192.168.42.149
			#./iptables -A PREROUTING -t nat -i ccinet3 -j DNAT --to-destination 192.168.42.149

			mkdir -p /data/misc/dhcp
			#dnsmasq needs these files priori run -eben if updated later
			touch /tmp/hosts
#*** u-blox modifications ***
# U_M39G_MV-349,U_M39G_MV-1380 M39G_MV_2-2500
			touch /tmp/resolv.conf
			echo "nameserver `getprop net.dns1`" > /tmp/resolv.conf
			chmod 666 /tmp/resolv.conf
# M39G_MV_2-364
			if [ $WIFI_ENABLE = '0' ]; then
#			dnsmasq -K -F ${IP_ADDRESS}00,${IP_ADDRESS}00,12h -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid < /dev/tty0
#			./dnsmasq -K -F $RNDIS0_DHCPSTART,$RNDIS0_DHCPSTOP,12h -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid < /dev/tty0
			if [ $DNSMASQ_CMD ]; then
				$DNSMASQ_CMD -K -F $RNDIS0_DHCPSTART,$RNDIS0_DHCPSTOP,12h -l ${TEMP_DIR}/dnsmasq.leases -x ${TEMP_DIR}/dnsmasq.pid -r /tmp/resolv.conf  < /dev/tty0
			fi 
##### u-blox modifications #####

			# Setting DNS server.
			# NOTE: This line should be removed when connectivity manager will be ready.
			#setprop net.dns1 8.8.8.8 - > set by mtil server on PDP up
# M39G_MV_2-364, M39G_MV_2-741
			else
				StartWiFiDelayed &
			fi
		fi
	fi
fi

# M39G_MV_2-1845
if [ $IP_TERMINATION_AUX = '4' ]; then
	if [ $SYSTEM_CONFIG_HOST = '3' ]; then
		echo "Running U-blox Wi-Fi in BRIDGE..." >> /dev/kmsg
			if [ $IPTABLES_CMD ]; then
				$IPTABLES_CMD -t nat -A POSTROUTING -o mlan0 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i mlan0 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o mlan0 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet0 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet0 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet0 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet1 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet1 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet1 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet2 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet2 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet2 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet3 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet3 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet3 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet4 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet4 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet4 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet5 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet5 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet5 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet6 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet6 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet6 -j ACCEPT
				$IPTABLES_CMD -t nat -A POSTROUTING -o ccinet7 -j MASQUERADE
				$IPTABLES_CMD -A FORWARD -i ccinet7 -o usb0 -m state --state RELATED,ESTABLISHED -j ACCEPT
				$IPTABLES_CMD -A FORWARD -i usb0 -o ccinet7 -j ACCEPT
				echo "1" > /proc/sys/net/ipv4/ip_forward
			fi
# U_M39G_MV-2240 M39G_MV_2-2500
		setprop net.dns1 8.8.8.8
		touch /tmp/resolv.conf
		echo "nameserver `getprop net.dns1`" > /tmp/resolv.conf
		chmod 666 /tmp/resolv.conf
		StartWiFiDelayed &
	fi
fi

##### u-blox modifications #####
#U_M39G_MV-89
# applied for bridge and router mode
 /bin/sh $NVMIptables
##### u-blox modifications #####
