#!/bin/sh
# Set variable upload_over: SD 1, USB 2
upload_over=1

if [ ! -e /dev/rdr ]; then
echo No RAMDUMP found > /dev/kmsg
exit 0
fi


echo 6 > /proc/sys/kernel/printk
echo 0 > /sys/devices/system/cpu/cpu0/timer_irq_latency
echo =========================================== > /dev/kmsg
echo RAMDUMP prepared by U-boot in RAM found > /dev/kmsg
echo The normal startup ABORTED for RAMDUMP uploading ... > /dev/kmsg
echo Script $0 is running > /dev/kmsg
echo upload_over == $upload_over > /dev/kmsg

# Use fixed File-Name:
#  RDNAME=RAMDUMP0000
# Use File-Name with RAMDUMP_YYMMDD-HHMM:
RDNAME=RAMDUMP_$(date +%y%m%d-%H%M)

if [ $upload_over -eq 1 ]; then
  echo ...Upload to SD /mnt/external_sdcard/$RDNAME.* > /dev/kmsg
  #echo t > /dev/rdr  - default
  cp /dev/rdr /mnt/external_sdcard/$RDNAME.txt
  echo d > /dev/rdr
  cp /dev/rdr /mnt/external_sdcard/$RDNAME.gz
  result=$?
else
  FTP_SERV_IP=`getprop persist.mrvl.ramdump.host_ip`
  RAMDUMP_USER=`getprop persist.mrvl.ramdump.user`
  echo ...Upload to FTP $FTP_SERV_IP > /dev/kmsg
  loop=0
  while [ $loop -le 5 ]
  do
    echo t > /dev/rdr
    busybox ftpput -u $RAMDUMP_USER $FTP_SERV_IP $RDNAME.txt /dev/rdr
    result=$?
    if [ $result -eq 0 ]; then
      echo d > /dev/rdr
      busybox ftpput -u $RAMDUMP_USER $FTP_SERV_IP $RDNAME.gz /dev/rdr
      result=$?
    fi

    if [ $result -eq 0 ]; then
      # Uploaded with ok. Exit loop
      loop=1000
    else
      # No answer from server or error. Try again
      loop=$((loop+1))
      echo FTP uploading retry ... > /dev/kmsg
      sleep 2
    fi
  done
fi

echo RAMDUMP upload finished with $result ----- Re-Start ---- > /dev/kmsg
# Clear ramdump descriptor before restart
echo c > /dev/rdr
reboot
