#!/bin/sh

#create COMCfg.prop file, in csv format
getprop | sed -e "s/\]: \[/,/g" -e "s/\]$//g" -ne "s/\[ro.mrvl.comm.\|\[persist.mrvl.comm.//gp" > /tmp/COMCfg.prop

#M39G_MV_2-1173 check /NVM permissions and correct them, if not sufficient
if [ `stat -c %a /NVM` \< 770 ]; then chmod 770 /NVM; fi

#create symlink to COMCfg.prop in /NVM if file is not empty
if [ -s /tmp/COMCfg.prop ]; then
 if [ ! -h /NVM/COMCfg.prop ]; then
	ln -s /tmp/COMCfg.prop /NVM/COMCfg.prop
 fi
else
 # tmp is empty, remove it and sym-link
 if [ -h /NVM/COMCfg.prop ]; then
	rm /NVM/COMCfg.prop
 fi
 rm /tmp/COMCfg.prop
fi

#create SymLink to APP files for COM in /NVM

#option 1 - from ro.mrvl.link2NVM property
LINK2NVM_PARAM=$(getprop ro.mrvl.link2NVM | awk -F"," '{for (i=1;i<=NF;i++){print $i}}')
#option 2 - from link2NVM file
LINK2NVM_PARAM="$LINK2NVM_PARAM $(cat /system/etc/link2NVM)"

for file in $(echo $LINK2NVM_PARAM)	; do
	if [ ! -e /NVM/"$file" -a ! -h /NVM/"$file" ]; then
		ln -s /system/marvell/tel/nvm_org/"$file" /NVM/"$file"
	fi
done

#option 3 - from rf_files_# plugin file
RF_PLUGIN_NUM=$(getprop ro.cmdline.RFPL)
RF_PLUGIN_FILE="/system/etc/rf_files_$RF_PLUGIN_NUM"

RF_PLUGIN_PARAM=$(cat "$RF_PLUGIN_FILE")

for files in $(echo $RF_PLUGIN_PARAM) ; do
	SRC=$(echo $files | awk -F"," '{print $1}')
	DST=$(echo $files | awk -F"," '{print $2}')

	if [ ! -e /NVM/"$DST" -a ! -h /NVM/"$DST" -a -e /system/etc/"$SRC" ]; then
		ln -s /system/etc/"$SRC" /NVM/"$DST"
	fi
done

#M39G_MV_2-804 Create symbolic links to audio configuration files (if not yet present)
if [ ! -h /NVM/voice.nvm ]; then
	ln -s -f /tmp/voice.nvm /NVM/voice.nvm
fi
if [ ! -h /NVM/audio_gain_calibration.xml ]; then
	ln -s -f /tmp/audio_gain_calibration.xml /NVM/audio_gain_calibration.xml
fi

#*** u-blox modification *** U_M39G_MV-474, U_M39G_MV-565
TOBY_HW_ID=`getprop ro.cmdline.BOAR`
UBLOX_CHAR_FACTORY_INIT=`getprop persist.sys.ublx_chf_fct_init`

if [ "$TOBY_HW_ID" == "d1" ]; then
	TTYPE=L200
fi
if [ "$TOBY_HW_ID" == "d2" ]; then
	TTYPE=L210
fi
if [ "$TOBY_HW_ID" == "d3" ]; then
	TTYPE=L280
fi
if [ "$TOBY_HW_ID" == "d4" ]; then
	TTYPE=L201
fi
if [ "$TOBY_HW_ID" == "d5" ]; then
	TTYPE=L220
fi
if [ "$TOBY_HW_ID" == "d6" ]; then
	TTYPE=R201
fi
if [ "$TOBY_HW_ID" == "d7" ]; then
	TTYPE=R210
fi
if [ "$TOBY_HW_ID" == "d8" ]; then
	TTYPE=R220
fi

#if property is not set then we need to copy the files
if [ -z "$UBLOX_CHAR_FACTORY_INIT" ] ; then
	cp /system/marvell/etc/"$TTYPE"_GsmCharData.nvm /NVM/GsmCharData.nvm
	cp /system/marvell/etc/"$TTYPE"_WbCharData.nvm /NVM/WbCharData.nvm
	cp /system/marvell/etc/"$TTYPE"_LteCharData.nvm /NVM/LteCharData.nvm

# M39G_MV_2-3034 overwrite JSC chardata files, if present
if dmesg | grep -q 'JSC 1G 128M 16-bit BCH'; then
	cp /system/marvell/etc/"$TTYPE"_JSC_LteCharData.nvm /NVM/LteCharData.nvm
	setprop persist.sys.ublx_nand_mnfct JSC
fi

	#set the flag so that on next reboot the file won't be copied
	setprop persist.sys.ublx_chf_fct_init 1
fi
#U_M39G_MV-474, U_M39G_MV-565

#M39G_MV_2-665
mkdir -p /data/userfs/audio/
if [ ! -e /data/userfs/audio/voice0.nvm ]; then
    cp /marvell/tel/nvm_org/voice.nvm /data/userfs/audio/voice0.nvm
fi
if [ ! -e /data/userfs/audio/voice1.nvm ]; then
    cp /marvell/tel/nvm_org/voice.nvm /data/userfs/audio/voice1.nvm
fi
if [ ! -e /data/userfs/audio/audio_gain_calibration0.xml ]; then
    cp /marvell/tel/nvm_org/audio_gain_calibration.xml /data/userfs/audio/audio_gain_calibration0.xml
fi
if [ ! -e /data/userfs/audio/audio_gain_calibration1.xml ]; then
    cp /marvell/tel/nvm_org/audio_gain_calibration.xml /data/userfs/audio/audio_gain_calibration1.xml
fi


#U_M39G_MV-373
UBLX_MRD_MPCI_INIT =`getprop persist.sys.mrd.ublox.init`

if [ -z "$UBLX_MRD_MPCI_INIT" ] || ["$UBLX_MRD_MPCI_INIT" == "0"]; then
	/marvell/tel/ublx_mrd_read
	# the init flags is set in ublx_mrd_read
fi
#U_M39G_MV-373


## U_M39G_MV-275
export TOBY_MPCI=`getprop persist.sys.mrd.ublox.mpci`

#uncomment for debug
#export TOBY_MPCI="1"

#*** u-blox modification *** U_M39G_MV-1127
if [ "$TOBY_MPCI" == "1" ] || [ "$TOBY_MPCI" == "2" ]; then
	setprop ro.mrvl.rf_gpio.enable true
	setprop ro.mrvl.rf_gpio.polarity false
else
	setprop ro.mrvl.rf_gpio.enable false
	setprop ro.mrvl.rf_gpio.polarity false
fi
### U_M39G_MV-275

### u-blox modification U_M39G_MV-431, U_M39G_MV-449, U_M39G_MV-1489
UDCONF_66=`getprop persist.sys.ublx_udconf_66`
if [ -z "$UDCONF_66" ]; then

	#IPv6 supported by default for all HW_IDs M39G_MV_2-2986
	setprop persist.sys.ublx_udconf_66 1

fi
#U_M39G_MV-431, U_M39G_MV-449, U_M39G_MV-1489

#U_M39G_MV-329, U_M39G_MV-485, M39G_MV_2-600, M39G_MV_2-633 M39G_MV_2-1145 M39G_MV_2-1283
UBLOX_FACTORY_INIT=`getprop persist.sys.ublx_factory_init`

# if property is set
if [ "$UBLOX_FACTORY_INIT" == "1" ]; then

	#create dir for EEH on first boot
	mkdir -p /cache/ublx_eeh/
	setprop persist.sys.ublx_eeh.sig_mask 0
	setprop persist.sys.ublx_eeh.sev 1

	# if factory init then copy COMCFG for AT&T only for L200
	if [ "$TOBY_HW_ID" == "d1" ]; then
		#overwrite AT&T COMCFG.csv for L200
		cp /NVM/COMCfg_ATT.csv /NVM/COMCfg.csv
	fi

fi
#U_M39G_MV-329, U_M39G_MV-485, M39G_MV_2-600, M39G_MV_2-633 M39G_MV_2-1145

#M39G_MV_2-1748,M39G_MV_2-1791 #comment the whole section after L200 has reached IP
#UBLOX_MTIL_UDP=`getprop persist.sys.ublx_mtil_udp`

# if property doesn't exist it means it was not set in the static build (the property doesn't exist only on L2XX-02S and L280-02S build)
#if [ -z "$UBLOX_MTIL_UDP" ]; then
#
#	#if HW is L210/L280 then close UDP since it reached IP, else OPEN
#	if [ "$TOBY_HW_ID" == "d2" ] || [ "$TOBY_HW_ID" == "d3" ]; then
#		setprop persist.sys.ublx_mtil_udp 0
#	else
#		setprop persist.sys.ublx_mtil_udp 1
#	fi
#fi
#M39G_MV_2-1748, M39G_MV_2-1791

#M39G_MV_2-336
UBLOX_UMWI=`getprop persist.sys.ublx_umwi_mode`

# if property is not there we need to configure the factory value
if [ -z "$UBLOX_UMWI" ]; then
	if [ "$TTYPE" == "L200" ] || [ "$TTYPE" == "L201" ]; then
		setprop persist.sys.ublx_umwi_mode 1
	else
		setprop persist.sys.ublx_umwi_mode 0
	fi
fi
#M39G_MV_2-336
