#!/system/xbin/sh

FOTA_CURRENT_VERSION=`tr -d '\n' < /NVM/ml_vers.txt`
if [ $? != 0 ] ; then
	echo "missing FOTA version file" > /dev/kmsg
	exit 1
fi

FOTA_IMEI=`tr -d '\n' < /NVM/ml_imei.txt`
if [ $? != 0 ] ; then
	FOTA_IMEI=$(getprop persist.mrvl.version.imei "")
	if [ -z "$FOTA_IMEI"] ; then
		echo "missing IMEI file" > /dev/kmsg
		exit 1
	fi
fi

MOUNT_POINT=$(getprop ro.mrvl.hawk.fota.mount_point /sdcard)
LOCAL_PATH=$(getprop ro.mrvl.hawk.fota.local_path "")

FOTA_SDCARD_MOUNT=$MOUNT_POINT$LOCAL_PATH
FOTA_SERVER_VERSION_FILENAME=VersionInfo.ini
FOTA_DOWNLOAD_VERSION_FILENAME=$FOTA_SDCARD_MOUNT/$FOTA_SERVER_VERSION_FILENAME
FOTA_DOWNLOAD_FIRMWARE_FILENAME=$FOTA_SDCARD_MOUNT/fa_pxa.zip

FOTA_SERVER=$(getprop ro.mrvl.hawk.fota.server.url ftp://212.199.69.13)
FOTA_SERVER_USERNAME=$(getprop ro.mrvl.hawk.fota.server.user FOTAClient)
FOTA_SERVER_PASSWD=$(getprop ro.mrvl.hawk.fota.server.pass yj1Hpugy)
FOTA_SERVER_DOWNLOAD_FILE_PATH=$FOTA_SERVER/Users/$FOTA_IMEI/$FOTA_SERVER_VERSION_FILENAME

# Download version file
curl --connect-timeout 20 -o $FOTA_DOWNLOAD_VERSION_FILENAME -u $FOTA_SERVER_USERNAME:$FOTA_SERVER_PASSWD $FOTA_SERVER_DOWNLOAD_FILE_PATH
exval=$?
echo "curl get_version exit value: $exval" > /dev/kmsg
if [ $exval == 0 ] ; then
	# get version number from .ini
	DOWNLOADED_VERSION=`cat $FOTA_DOWNLOAD_VERSION_FILENAME | grep firmware_version | cut -d '=' -f2`
	if [ -n "$DOWNLOADED_VERSION" ] ; then
		#remove new line
		DOWNLOADED_VERSION=`echo ${DOWNLOADED_VERSION%?}`
		if [ "$FOTA_CURRENT_VERSION" != "$DOWNLOADED_VERSION" ] ; then
			#download firmware from ftp
            DOWNLOAD_PATH=`cat $FOTA_DOWNLOAD_VERSION_FILENAME | grep firmware_link | cut -d '=' -f2`
            DOWNLOAD_MD5=`cat $FOTA_DOWNLOAD_VERSION_FILENAME | grep firmware_md5 | cut -d '=' -f2`
            #remove new line
            DOWNLOAD_PATH=`echo ${DOWNLOAD_PATH%?}`
            DOWNLOAD_MD5=`echo ${DOWNLOAD_MD5%?}`
            curl --connect-timeout 20 -o $FOTA_DOWNLOAD_FIRMWARE_FILENAME -u $FOTA_SERVER_USERNAME:$FOTA_SERVER_PASSWD $FOTA_SERVER/$DOWNLOAD_PATH
			exval=$?
			echo "curl get_firmware exit value: $exval" > /dev/kmsg
			if [ $exval == 0 ] ;then
				echo "Download success...start firmware upgrade"
				#force run upgrade script
				if echo "$DOWNLOAD_PATH" | egrep -q "*fbf.gz*" ; then
					eshel_fota.sh $FOTA_DOWNLOAD_FIRMWARE_FILENAME $DOWNLOAD_MD5
				else
					android_fota.sh $FOTA_DOWNLOAD_FIRMWARE_FILENAME $DOWNLOAD_MD5
				fi
			fi
		else
			echo "No new version found..."  > /dev/kmsg
		fi
	else
		echo "Version description not found..."  > /dev/kmsg
	fi
fi
