#!/bin/sh

dest_fbf=/mnt/external_sdcard/fa_pxa.fbf

start=`date +%s`
srczip=$1
if [ -z "$srczip" -o  ! -f $srczip ];then
	echo "File not found \"$srczip\". Please provide valid file."
	exit 1
fi

srczip_md5="$2"
if [ -z "$2" ];then
	echo "FOTA md5 signature missing - skip test."
else
	md5=`md5sum $srczip |  cut -d " " -f 1`
	if [ "$md5" != "$srczip_md5" ]; then
		echo "FOTA image is incorrect,update failed"
		exit 1
	else
		echo "FOTA image md5 OK."
	fi
fi
# Disable PANIC DRAW after we kill telephony processes
echo 1 > /sys/module/seh/parameters/hawk_fota_active

gunzip -c $srczip > $dest_fbf
sync

end=`date +%s`
echo "FOTA FBF IMAGE set on FLASH in $((end-start)) seconds."
# DO NOT CHANGE bellow print - since User Test APK parses it.
echo "FOTA REBOOT."
eeh -F
