--Scan for nearby BLE beacons (ELA) and report data to TCP

--      Create a table with events to handle
actions = {}

local tags = 0    -- lists the tags scanned 
local sf = string.format
local email_temp = 0
local email_hum = 0
local e, str
e, str = avl.pfal("CNF.Get,REPLACE0")
local replace0 = string.sub(str, 11, -3)

function string.reversebytes(h)
  local res = h
  local hex = ''
  for i = 0, #h, 2 do
      hex = string.sub(res, 0, 2) .. hex
      res = string.sub(res, 3, string.len(h))  
  end
  return hex
end

function string.twoCompliment(v)
    local f_two_c = string.format("%x", bit32.bnot(v))
    return tonumber(string.sub(f_two_c, 5, 8), 16)
end;

function string.convert_temp(d) 
local dm = d
  if d > 61439 then
      dm = string.twoCompliment(d)
     if dm == 0 then dm = 1 end
     dm = 0 - dm
  end
  return dm
end

function string.BinToHex(s)
  b2h = { ["0000"] = "0", ["0001"] = "1", ["0010"] = "2", ["0011"] = "3", ["0100"] = "4", ["0101"] = "5", ["0110"] = "6", ["0111"] = "7", ["1000"] = "8", ["1001"] = "9", ["1010"] = "A", ["1011"] = "B", ["1100"] = "C", ["1101"] = "D",["1110"] = "E", ["1111"] = "F"}
  local out = ''
  for i = 1, string.len(s), 4 do
    bin = string.sub(s, i, i+3)
    out = out..b2h[bin]
  end
  return out
end

function string.HexToBin(s)
  h2b = { ["0"] = "0000", ["1"] = "0001", ["2"] = "0010", ["3"] = "0011", ["4"] = "0100", ["5"] = "0101", ["6"] = "0110",["7"] = "0111", ["8"] = "1000", ["9"] = "1001", ["A"] = "1010", ["B"] = "1011", ["C"] = "1100", ["D"] = "1101",["E"] = "1110", ["F"] = "1111"}
  local out=''
  local hex, i
  for i = 1, string.len(s) do
      hex = string.sub(s, i, i)
      out = out..h2b[hex] 
  end
  return out
end

actions[ALARM_SYS_BLE_TAGDATA] = function(ev) -- Generated whenever tags advertise Manufacture Specific Data
  os.trace("DATA = [%s]", ev.u_string)
  local _, _, MAC, RSSI, UUID = string.find(ev.u_string,"([^,]+),([^,]+),(%w+)")
  local cfMAC = MAC  
  local tcpMAC = "GPLTRX|ble|" .. replace0 .. "|" ..MAC.. "|"..RSSI
  print("LUA: tcp_cmd ", tcpMAC)
  local _mid = string.reversebytes(string.sub(UUID, 1, 4))
  local _tid = string.sub(UUID, 5, 6);
  local ela = string.sub(UUID, 1, -1)
  if (_mid == '0757') and (_tid == '12') then -- Manufacture ID [0757 = ELA] &  PUCK/COIN T
      f_temp = string.reversebytes(string.sub(ela, 7, 11));
      f_deg = string.convert_temp(tonumber(f_temp, 16)) * 0.01;      
      tcpMAC = tcpMAC.. "|" ..f_deg
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_t|")
      avl.pfal(string.format("MSG.Send.TCP,0,\"%s\"", tcpMAC))      
  elseif (_mid == '0757') and (_tid == '21') then -- Manufacture ID [0757 = ELA] &  PUCK/COIN RHT
      f_hum = string.sub(ela, 7, 8); -- Humidity data
      f_persent = tonumber(f_hum, 16);
      f_temp = string.reversebytes(string.sub(ela, 11, 15)); -- Temperature data
      f_deg = string.convert_temp(tonumber(f_temp, 16)) * 0.01;
      tcpMAC = tcpMAC.."|"..f_deg.."|"..f_persent
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_rht|")
      avl.pfal(string.format("MSG.Send.TCP,0,\"%s\"", tcpMAC))
  elseif (_mid == '0757') and (_tid == '32') then -- Manufacture ID [0757 = ELA] &  PUCK/COIN MAG
      _fmag = string.reversebytes(string.sub(ela, 7, 11));
      _ftoBin = string.HexToBin(_fmag);
      fCnt =  tonumber(string.BinToHex(string.sub('0'.._ftoBin, 1, 16)), 16);
      fState = tonumber(string.sub(_ftoBin,-1));      
      tcpMAC = tcpMAC.."|"..fCnt.."|"..fState
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_mag|")
      avl.pfal(sf("MSG.Send.TCP,0,\"%s\"", tcpMAC))
  elseif (_mid == '0757') and (_tid == '06') then -- Manufacture ID [0757 = ELA] &  PUCK/COIN ID 
      _fId = string.reversebytes(string.sub(ela, 7, 18));      
      tcpMAC = tcpMAC.."|".._fId
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_id|")
      avl.pfal(sf("MSG.Send.TCP,0,\"%s\"", tcpMAC))      
  elseif (_mid == '0757') and (_tid == '42') then -- Manufacture ID [0757 = ELA] &  PUCK/COIN MOV
      f_mov = string.reversebytes(string.sub(ela, 7, 11));
      f_toBin = string.HexToBin(f_mov); 
      f_mov_cnt =  tonumber(string.BinToHex(string.sub('0'..f_toBin, 1, 16)), 16);
      f_mov_state = tonumber(string.sub(f_toBin, -1));      
      tcpMAC = tcpMAC.."|"..f_mov_cnt.."|"..f_mov_state
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_mov|")
      avl.pfal(sf("MSG.Send.TCP,0,\"%s\"", tcpMAC))      
  elseif (_mid == '0757') and (_tid == '56') then -- Manufacture ID [0757 = ELA] &  PUCK/COIN ANG
      ang = string.sub(ela, 7, 18);
      x = string.ReverseBytes(string.sub(ang, 1, 4));
      y = string.ReverseBytes(string.sub(ang, 5, 8));
      z = string.ReverseBytes(string.sub(ang, 9, 12));
      ang_x = string.Convert(tonumber(x, 16));
      ang_y = string.Convert(tonumber(y, 16));
      ang_z = string.Convert(tonumber(z, 16));      
      tcpMAC = tcpMAC.."|"..ang_x.."|"..ang_y.."|"..ang_z
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_ang|")
      avl.pfal(sf("MSG.Send.TCP,0,\"%s\"", tcpMAC))
  elseif (_mid == '0757') and (_tid == 'F1') then  -- ELA Battery service id - It is sent when battery <15% 
      f_bat = tonumber(string.sub(UUID, -2), 16)
      f_lev = tointeger(f_bat)
      tcpMAC = tcpMAC.."|"..f_lev
      tcpMAC = tcpMAC:gsub("|ble|", "|ble_bat|")
      avl.pfal(sf("MSG.Send.TCP,0,\"%s\"", tcpMAC))
  end
  tags = tags+1
end;

actions[ALARM_SYS_BLE_SCANEND] = function(ev)
  os.trace("found %d tags in the hood", tags);
  tags = 0;
end

avl.useevent(ALARM_SYS_BLE_TAGDATA)

while 1 do  -- This is the mainloop of the script
  local ev = avl.event(1000)
  if (ev ~= nil) then 
    local type = ev.type
    if actions[type] ~= nil then
      actions[type](ev)
    end
  end
end